// este code es el que hay que agregar en el functions.php de Wordpress
// Asegúrate de reemplazar 'nombre_de_la_tabla' con el nombre de la tabla personalizada en tu base de datos de WordPress donde deseas almacenar los datos del formulario.

function guardar_datos_formulario($datos) {
    global $wpdb;
    
    // Obtiene los valores del formulario
    $finca = $datos['finca'];
    $folio = $datos['folio'];
    $libro = $datos['libro'];
    $avaluo_ultimos_12_meses = isset($datos['avaluo_ultimos_12_meses']) ? 'Sí' : 'No';
    $valor_avaluo = $datos['valor_avaluo'];
    $tipo_avaluo = $datos['tipo_avaluo'];
    $abierto_a = $datos['abierto_a'];
    $descripcion_inmueble = $datos['descripcion_inmueble'];
    
    // Guarda los datos en la base de datos
    $tabla = $wpdb->prefix . 'nombre_de_la_tabla'; // Reemplaza 'nombre_de_la_tabla' con el nombre de tu tabla personalizada
    
    $wpdb->insert(
        $tabla,
        array(
            'finca' => $finca,
            'folio' => $folio,
            'libro' => $libro,
            'avaluo_ultimos_12_meses' => $avaluo_ultimos_12_meses,
            'valor_avaluo' => $valor_avaluo,
            'tipo_avaluo' => $tipo_avaluo,
            'abierto_a' => $abierto_a,
            'descripcion_inmueble' => $descripcion_inmueble,
        )
    );
}

add_action('wp_ajax_guardar_formulario', 'guardar_datos_formulario');
add_action('wp_ajax_nopriv_guardar_formulario', 'guardar_datos_formulario');
